import Toybox.Lang;
import Toybox.WatchUi;

class TestTextPickerDelegate extends TextPickerDelegate {
    function initialize() {
        TextPickerDelegate.initialize();
    }

    /*
    Expected behavior:
    1. During text entry, view stack is TestView -> TextPicker.
    2. After text entry, system pops TextPicker and *then* calls
       onTextEntered, leaving only TestView.
    3. onTextEntered calls switchToView, replacing initial TestView with one
       displaying the entered text.
    4. The user ends up at the "Entered: " scrfeen, and navigating back exits
       the app.
    
    Observed behavior:
    1. During text entry, view stack is TestView -> TextPicker.
    2. After text entry, system calls onTextEntered *immediately*, with
       TextPicker still on the view stack.
    3. onTextEntered calls switchToView, replacing *TextPicker* with a TestView
       displaying the entered text.
    4. After onTextEntered returns, system pops what it *thinks* is TextPicker
       but is *actually* the new TestView, leaving us at the *original*
       TestView.
    5. The user never sees the "Entered:" screen.
    */
    function onTextEntered(text as String, changed as Boolean) as Boolean {
        WatchUi.switchToView(new TestView("Entered: " + text), null, SLIDE_LEFT);
        return true;
    }

    /*
    Expected behavior:
    1. During text entry, view stack is TestView -> TextPicker.
    2. On cancellation, system pops TextPicker and *then* calls onCancel,
       leaving only TestView.
    3. onCancel calls pushView, pushing a new TestView displaying "Canceled!"
       on top of the initial TestView.
    4. The user ends up at the "Canceled!" screen, and navigating back returns
       to the initial TestView.
    
    Observed behavior:
    1. During text entry, view stack is TestView -> TextPicker.
    2. On cancellation, system calls onCancel *immediately*, with TextPicker
       still on the view stack.
    3. onCancel calls pushView, pushing a new TestView displaying "Canceled!"
       on top of the *TextPicker*.
    4. After onCancel returns, system pops what it *thinks* is TextPicker
       but is *actually* the new TestView, leaving us back at the TextPicker.
    5. The user ends up stuck in the TextPicker.
    */
    function onCancel() as Boolean {
        WatchUi.pushView(new TestView("Canceled!"), null, SLIDE_LEFT);
        return true;
    }
}